///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 1995/2004 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor : Xilinx
// \   \   \/     Version : 10.1
//  \   \         Description : Xilinx Functional Simulation Library Component
//  /   /                  Power PC Core
// /___/   /\     Filename : PPC405_ADV.v
// \   \  /  \    Timestamp : Fri Jun 18 10:57:22 PDT 2004
//  \___\/\___\
//
// Revision:
//    03/23/04 - Initial version.

`timescale 1 ps / 1 ps

module PPC405_ADV (
	APUFCMDECODED,
	APUFCMDECUDI,
	APUFCMDECUDIVALID,
	APUFCMENDIAN,
	APUFCMFLUSH,
	APUFCMINSTRUCTION,
	APUFCMINSTRVALID,
	APUFCMLOADBYTEEN,
	APUFCMLOADDATA,
	APUFCMLOADDVALID,
	APUFCMOPERANDVALID,
	APUFCMRADATA,
	APUFCMRBDATA,
	APUFCMWRITEBACKOK,
	APUFCMXERCA,
	C405CPMCORESLEEPREQ,
	C405CPMMSRCE,
	C405CPMMSREE,
	C405CPMTIMERIRQ,
	C405CPMTIMERRESETREQ,
	C405DBGLOADDATAONAPUDBUS,
	C405DBGMSRWE,
	C405DBGSTOPACK,
	C405DBGWBCOMPLETE,
	C405DBGWBFULL,
	C405DBGWBIAR,
	C405JTGCAPTUREDR,
	C405JTGEXTEST,
	C405JTGPGMOUT,
	C405JTGSHIFTDR,
	C405JTGTDO,
	C405JTGTDOEN,
	C405JTGUPDATEDR,
	C405PLBDCUABORT,
	C405PLBDCUABUS,
	C405PLBDCUBE,
	C405PLBDCUCACHEABLE,
	C405PLBDCUGUARDED,
	C405PLBDCUPRIORITY,
	C405PLBDCUREQUEST,
	C405PLBDCURNW,
	C405PLBDCUSIZE2,
	C405PLBDCUU0ATTR,
	C405PLBDCUWRDBUS,
	C405PLBDCUWRITETHRU,
	C405PLBICUABORT,
	C405PLBICUABUS,
	C405PLBICUCACHEABLE,
	C405PLBICUPRIORITY,
	C405PLBICUREQUEST,
	C405PLBICUSIZE,
	C405PLBICUU0ATTR,
	C405RSTCHIPRESETREQ,
	C405RSTCORERESETREQ,
	C405RSTSYSRESETREQ,
	C405TRCCYCLE,
	C405TRCEVENEXECUTIONSTATUS,
	C405TRCODDEXECUTIONSTATUS,
	C405TRCTRACESTATUS,
	C405TRCTRIGGEREVENTOUT,
	C405TRCTRIGGEREVENTTYPE,
	C405XXXMACHINECHECK,
	DCREMACABUS,
	DCREMACCLK,
	DCREMACDBUS,
	DCREMACENABLER,
	DCREMACREAD,
	DCREMACWRITE,
	DSOCMBRAMABUS,
	DSOCMBRAMBYTEWRITE,
	DSOCMBRAMEN,
	DSOCMBRAMWRDBUS,
	DSOCMBUSY,
	DSOCMRDADDRVALID,
	DSOCMWRADDRVALID,
	EXTDCRABUS,
	EXTDCRDBUSOUT,
	EXTDCRREAD,
	EXTDCRWRITE,
	ISOCMBRAMEN,
	ISOCMBRAMEVENWRITEEN,
	ISOCMBRAMODDWRITEEN,
	ISOCMBRAMRDABUS,
	ISOCMBRAMWRABUS,
	ISOCMBRAMWRDBUS,
	ISOCMDCRBRAMEVENEN,
	ISOCMDCRBRAMODDEN,
	ISOCMDCRBRAMRDSELECT,
	BRAMDSOCMCLK,
	BRAMDSOCMRDDBUS,
	BRAMISOCMCLK,
	BRAMISOCMDCRRDDBUS,
	BRAMISOCMRDDBUS,
	CPMC405CLOCK,
	CPMC405CORECLKINACTIVE,
	CPMC405CPUCLKEN,
	CPMC405JTAGCLKEN,
	CPMC405SYNCBYPASS,
	CPMC405TIMERCLKEN,
	CPMC405TIMERTICK,
	CPMDCRCLK,
	CPMFCMCLK,
	DBGC405DEBUGHALT,
	DBGC405EXTBUSHOLDACK,
	DBGC405UNCONDDEBUGEVENT,
	DSARCVALUE,
	DSCNTLVALUE,
	DSOCMRWCOMPLETE,
	EICC405CRITINPUTIRQ,
	EICC405EXTINPUTIRQ,
	EMACDCRACK,
	EMACDCRDBUS,
	EXTDCRACK,
	EXTDCRDBUSIN,
	FCMAPUCR,
	FCMAPUDCDCREN,
	FCMAPUDCDFORCEALIGN,
	FCMAPUDCDFORCEBESTEERING,
	FCMAPUDCDFPUOP,
	FCMAPUDCDGPRWRITE,
	FCMAPUDCDLDSTBYTE,
	FCMAPUDCDLDSTDW,
	FCMAPUDCDLDSTHW,
	FCMAPUDCDLDSTQW,
	FCMAPUDCDLDSTWD,
	FCMAPUDCDLOAD,
	FCMAPUDCDPRIVOP,
	FCMAPUDCDRAEN,
	FCMAPUDCDRBEN,
	FCMAPUDCDSTORE,
	FCMAPUDCDTRAPBE,
	FCMAPUDCDTRAPLE,
	FCMAPUDCDUPDATE,
	FCMAPUDCDXERCAEN,
	FCMAPUDCDXEROVEN,
	FCMAPUDECODEBUSY,
	FCMAPUDONE,
	FCMAPUEXCEPTION,
	FCMAPUEXEBLOCKINGMCO,
	FCMAPUEXECRFIELD,
	FCMAPUEXENONBLOCKINGMCO,
	FCMAPUINSTRACK,
	FCMAPULOADWAIT,
	FCMAPURESULT,
	FCMAPURESULTVALID,
	FCMAPUSLEEPNOTREADY,
	FCMAPUXERCA,
	FCMAPUXEROV,
	ISARCVALUE,
	ISCNTLVALUE,
	JTGC405BNDSCANTDO,
	JTGC405TCK,
	JTGC405TDI,
	JTGC405TMS,
	JTGC405TRSTNEG,
	MCBCPUCLKEN,
	MCBJTAGEN,
	MCBTIMEREN,
	MCPPCRST,
	PLBC405DCUADDRACK,
	PLBC405DCUBUSY,
	PLBC405DCUERR,
	PLBC405DCURDDACK,
	PLBC405DCURDDBUS,
	PLBC405DCURDWDADDR,
	PLBC405DCUSSIZE1,
	PLBC405DCUWRDACK,
	PLBC405ICUADDRACK,
	PLBC405ICUBUSY,
	PLBC405ICUERR,
	PLBC405ICURDDACK,
	PLBC405ICURDDBUS,
	PLBC405ICURDWDADDR,
	PLBC405ICUSSIZE1,
	PLBCLK,
	RSTC405RESETCHIP,
	RSTC405RESETCORE,
	RSTC405RESETSYS,
	TIEAPUCONTROL,
	TIEAPUUDI1,
	TIEAPUUDI2,
	TIEAPUUDI3,
	TIEAPUUDI4,
	TIEAPUUDI5,
	TIEAPUUDI6,
	TIEAPUUDI7,
	TIEAPUUDI8,
	TIEC405DETERMINISTICMULT,
	TIEC405DISOPERANDFWD,
	TIEC405MMUEN,
	TIEDCRADDR,
	TIEPVRBIT10,
	TIEPVRBIT11,
	TIEPVRBIT28,
	TIEPVRBIT29,
	TIEPVRBIT30,
	TIEPVRBIT31,
	TIEPVRBIT8,
	TIEPVRBIT9,
	TRCC405TRACEDISABLE,
	TRCC405TRIGGEREVENTIN
);

localparam in_delay=1;
localparam out_delay=100;

output APUFCMDECODED;
output APUFCMDECUDIVALID;
output APUFCMENDIAN;
output APUFCMFLUSH;
output APUFCMINSTRVALID;
output APUFCMLOADDVALID;
output APUFCMOPERANDVALID;
output APUFCMWRITEBACKOK;
output APUFCMXERCA;
output C405CPMCORESLEEPREQ;
output C405CPMMSRCE;
output C405CPMMSREE;
output C405CPMTIMERIRQ;
output C405CPMTIMERRESETREQ;
output C405DBGLOADDATAONAPUDBUS;
output C405DBGMSRWE;
output C405DBGSTOPACK;
output C405DBGWBCOMPLETE;
output C405DBGWBFULL;
output C405JTGCAPTUREDR;
output C405JTGEXTEST;
output C405JTGPGMOUT;
output C405JTGSHIFTDR;
output C405JTGTDO;
output C405JTGTDOEN;
output C405JTGUPDATEDR;
output C405PLBDCUABORT;
output C405PLBDCUCACHEABLE;
output C405PLBDCUGUARDED;
output C405PLBDCUREQUEST;
output C405PLBDCURNW;
output C405PLBDCUSIZE2;
output C405PLBDCUU0ATTR;
output C405PLBDCUWRITETHRU;
output C405PLBICUABORT;
output C405PLBICUCACHEABLE;
output C405PLBICUREQUEST;
output C405PLBICUU0ATTR;
output C405RSTCHIPRESETREQ;
output C405RSTCORERESETREQ;
output C405RSTSYSRESETREQ;
output C405TRCCYCLE;
output C405TRCTRIGGEREVENTOUT;
output C405XXXMACHINECHECK;
output DCREMACCLK;
output DCREMACENABLER;
output DCREMACREAD;
output DCREMACWRITE;
output DSOCMBRAMEN;
output DSOCMBUSY;
output DSOCMRDADDRVALID;
output DSOCMWRADDRVALID;
output EXTDCRREAD;
output EXTDCRWRITE;
output ISOCMBRAMEN;
output ISOCMBRAMEVENWRITEEN;
output ISOCMBRAMODDWRITEEN;
output ISOCMDCRBRAMEVENEN;
output ISOCMDCRBRAMODDEN;
output ISOCMDCRBRAMRDSELECT;
output [0:10] C405TRCTRIGGEREVENTTYPE;
output [0:1] C405PLBDCUPRIORITY;
output [0:1] C405PLBICUPRIORITY;
output [0:1] C405TRCEVENEXECUTIONSTATUS;
output [0:1] C405TRCODDEXECUTIONSTATUS;
output [0:29] C405DBGWBIAR;
output [0:29] C405PLBICUABUS;
output [0:2] APUFCMDECUDI;
output [0:31] APUFCMINSTRUCTION;
output [0:31] APUFCMLOADDATA;
output [0:31] APUFCMRADATA;
output [0:31] APUFCMRBDATA;
output [0:31] C405PLBDCUABUS;
output [0:31] DCREMACDBUS;
output [0:31] DSOCMBRAMWRDBUS;
output [0:31] EXTDCRDBUSOUT;
output [0:31] ISOCMBRAMWRDBUS;
output [0:3] APUFCMLOADBYTEEN;
output [0:3] C405TRCTRACESTATUS;
output [0:3] DSOCMBRAMBYTEWRITE;
output [0:63] C405PLBDCUWRDBUS;
output [0:7] C405PLBDCUBE;
output [0:9] EXTDCRABUS;
output [2:3] C405PLBICUSIZE;
output [8:28] ISOCMBRAMRDABUS;
output [8:28] ISOCMBRAMWRABUS;
output [8:29] DSOCMBRAMABUS;
output [8:9] DCREMACABUS;

input BRAMDSOCMCLK;
input BRAMISOCMCLK;
input CPMC405CLOCK;
input CPMC405CORECLKINACTIVE;
input CPMC405CPUCLKEN;
input CPMC405JTAGCLKEN;
input CPMC405SYNCBYPASS;
input CPMC405TIMERCLKEN;
input CPMC405TIMERTICK;
input CPMDCRCLK;
input CPMFCMCLK;
input DBGC405DEBUGHALT;
input DBGC405EXTBUSHOLDACK;
input DBGC405UNCONDDEBUGEVENT;
input DSOCMRWCOMPLETE;
input EICC405CRITINPUTIRQ;
input EICC405EXTINPUTIRQ;
input EMACDCRACK;
input EXTDCRACK;
input FCMAPUDCDCREN;
input FCMAPUDCDFORCEALIGN;
input FCMAPUDCDFORCEBESTEERING;
input FCMAPUDCDFPUOP;
input FCMAPUDCDGPRWRITE;
input FCMAPUDCDLDSTBYTE;
input FCMAPUDCDLDSTDW;
input FCMAPUDCDLDSTHW;
input FCMAPUDCDLDSTQW;
input FCMAPUDCDLDSTWD;
input FCMAPUDCDLOAD;
input FCMAPUDCDPRIVOP;
input FCMAPUDCDRAEN;
input FCMAPUDCDRBEN;
input FCMAPUDCDSTORE;
input FCMAPUDCDTRAPBE;
input FCMAPUDCDTRAPLE;
input FCMAPUDCDUPDATE;
input FCMAPUDCDXERCAEN;
input FCMAPUDCDXEROVEN;
input FCMAPUDECODEBUSY;
input FCMAPUDONE;
input FCMAPUEXCEPTION;
input FCMAPUEXEBLOCKINGMCO;
input FCMAPUEXENONBLOCKINGMCO;
input FCMAPUINSTRACK;
input FCMAPULOADWAIT;
input FCMAPURESULTVALID;
input FCMAPUSLEEPNOTREADY;
input FCMAPUXERCA;
input FCMAPUXEROV;
input JTGC405BNDSCANTDO;
input JTGC405TCK;
input JTGC405TDI;
input JTGC405TMS;
input JTGC405TRSTNEG;
input MCBCPUCLKEN;
input MCBJTAGEN;
input MCBTIMEREN;
input MCPPCRST;
input PLBC405DCUADDRACK;
input PLBC405DCUBUSY;
input PLBC405DCUERR;
input PLBC405DCURDDACK;
input PLBC405DCUSSIZE1;
input PLBC405DCUWRDACK;
input PLBC405ICUADDRACK;
input PLBC405ICUBUSY;
input PLBC405ICUERR;
input PLBC405ICURDDACK;
input PLBC405ICUSSIZE1;
input PLBCLK;
input RSTC405RESETCHIP;
input RSTC405RESETCORE;
input RSTC405RESETSYS;
input TIEC405DETERMINISTICMULT;
input TIEC405DISOPERANDFWD;
input TIEC405MMUEN;
input TIEPVRBIT10;
input TIEPVRBIT11;
input TIEPVRBIT28;
input TIEPVRBIT29;
input TIEPVRBIT30;
input TIEPVRBIT31;
input TIEPVRBIT8;
input TIEPVRBIT9;
input TRCC405TRACEDISABLE;
input TRCC405TRIGGEREVENTIN;
input [0:15] TIEAPUCONTROL;
input [0:23] TIEAPUUDI1;
input [0:23] TIEAPUUDI2;
input [0:23] TIEAPUUDI3;
input [0:23] TIEAPUUDI4;
input [0:23] TIEAPUUDI5;
input [0:23] TIEAPUUDI6;
input [0:23] TIEAPUUDI7;
input [0:23] TIEAPUUDI8;
input [0:2] FCMAPUEXECRFIELD;
input [0:31] BRAMDSOCMRDDBUS;
input [0:31] BRAMISOCMDCRRDDBUS;
input [0:31] EMACDCRDBUS;
input [0:31] EXTDCRDBUSIN;
input [0:31] FCMAPURESULT;
input [0:3] FCMAPUCR;
input [0:5] TIEDCRADDR;
input [0:63] BRAMISOCMRDDBUS;
input [0:63] PLBC405DCURDDBUS;
input [0:63] PLBC405ICURDDBUS;
input [0:7] DSARCVALUE;
input [0:7] DSCNTLVALUE;
input [0:7] ISARCVALUE;
input [0:7] ISCNTLVALUE;
input [1:3] PLBC405DCURDWDADDR;
input [1:3] PLBC405ICURDWDADDR;

wire APUFCMDECODED_delay;
wire APUFCMDECUDIVALID_delay;
wire APUFCMENDIAN_delay;
wire APUFCMFLUSH_delay;
wire APUFCMINSTRVALID_delay;
wire APUFCMLOADDVALID_delay;
wire APUFCMOPERANDVALID_delay;
wire APUFCMWRITEBACKOK_delay;
wire APUFCMXERCA_delay;
wire BRAMDSOCMCLK_delay;
wire BRAMISOCMCLK_delay;
wire C405CPMCORESLEEPREQ_delay;
wire C405CPMMSRCE_delay;
wire C405CPMMSREE_delay;
wire C405CPMTIMERIRQ_delay;
wire C405CPMTIMERRESETREQ_delay;
wire C405DBGLOADDATAONAPUDBUS_delay;
wire C405DBGMSRWE_delay;
wire C405DBGSTOPACK_delay;
wire C405DBGWBCOMPLETE_delay;
wire C405DBGWBFULL_delay;
wire C405JTGCAPTUREDR_delay;
wire C405JTGEXTEST_delay;
wire C405JTGPGMOUT_delay;
wire C405JTGSHIFTDR_delay;
wire C405JTGTDOEN_delay;
wire C405JTGTDO_delay;
wire C405JTGUPDATEDR_delay;
wire C405PLBDCUABORT_delay;
wire C405PLBDCUCACHEABLE_delay;
wire C405PLBDCUGUARDED_delay;
wire C405PLBDCUREQUEST_delay;
wire C405PLBDCURNW_delay;
wire C405PLBDCUSIZE2_delay;
wire C405PLBDCUU0ATTR_delay;
wire C405PLBDCUWRITETHRU_delay;
wire C405PLBICUABORT_delay;
wire C405PLBICUCACHEABLE_delay;
wire C405PLBICUREQUEST_delay;
wire C405PLBICUU0ATTR_delay;
wire C405RSTCHIPRESETREQ_delay;
wire C405RSTCORERESETREQ_delay;
wire C405RSTSYSRESETREQ_delay;
wire C405TRCCYCLE_delay;
wire C405TRCTRIGGEREVENTOUT_delay;
wire C405XXXMACHINECHECK_delay;
wire CPMC405CLOCK_delay;
wire CPMC405CORECLKINACTIVE_delay;
wire CPMC405CPUCLKEN_delay;
wire CPMC405JTAGCLKEN_delay;
wire CPMC405SYNCBYPASS_delay;
wire CPMC405TIMERCLKEN_delay;
wire CPMC405TIMERTICK_delay;
wire CPMDCRCLK_delay;
wire CPMFCMCLK_delay;
wire DBGC405DEBUGHALT_delay;
wire DBGC405EXTBUSHOLDACK_delay;
wire DBGC405UNCONDDEBUGEVENT_delay;
wire DCREMACCLK_delay;
wire DCREMACENABLER_delay;
wire DCREMACREAD_delay;
wire DCREMACWRITE_delay;
wire DSOCMBRAMEN_delay;
wire DSOCMBUSY_delay;
wire DSOCMRDADDRVALID_delay;
wire DSOCMRWCOMPLETE_delay;
wire DSOCMWRADDRVALID_delay;
wire EICC405CRITINPUTIRQ_delay;
wire EICC405EXTINPUTIRQ_delay;
wire EMACDCRACK_delay;
wire EXTDCRACK_delay;
wire EXTDCRREAD_delay;
wire EXTDCRWRITE_delay;
wire FCMAPUDCDCREN_delay;
wire FCMAPUDCDFORCEALIGN_delay;
wire FCMAPUDCDFORCEBESTEERING_delay;
wire FCMAPUDCDFPUOP_delay;
wire FCMAPUDCDGPRWRITE_delay;
wire FCMAPUDCDLDSTBYTE_delay;
wire FCMAPUDCDLDSTDW_delay;
wire FCMAPUDCDLDSTHW_delay;
wire FCMAPUDCDLDSTQW_delay;
wire FCMAPUDCDLDSTWD_delay;
wire FCMAPUDCDLOAD_delay;
wire FCMAPUDCDPRIVOP_delay;
wire FCMAPUDCDRAEN_delay;
wire FCMAPUDCDRBEN_delay;
wire FCMAPUDCDSTORE_delay;
wire FCMAPUDCDTRAPBE_delay;
wire FCMAPUDCDTRAPLE_delay;
wire FCMAPUDCDUPDATE_delay;
wire FCMAPUDCDXERCAEN_delay;
wire FCMAPUDCDXEROVEN_delay;
wire FCMAPUDECODEBUSY_delay;
wire FCMAPUDONE_delay;
wire FCMAPUEXCEPTION_delay;
wire FCMAPUEXEBLOCKINGMCO_delay;
wire FCMAPUEXENONBLOCKINGMCO_delay;
wire FCMAPUINSTRACK_delay;
wire FCMAPULOADWAIT_delay;
wire FCMAPURESULTVALID_delay;
wire FCMAPUSLEEPNOTREADY_delay;
wire FCMAPUXERCA_delay;
wire FCMAPUXEROV_delay;
wire ISOCMBRAMEN_delay;
wire ISOCMBRAMEVENWRITEEN_delay;
wire ISOCMBRAMODDWRITEEN_delay;
wire ISOCMDCRBRAMEVENEN_delay;
wire ISOCMDCRBRAMODDEN_delay;
wire ISOCMDCRBRAMRDSELECT_delay;
wire JTGC405BNDSCANTDO_delay;
wire JTGC405TCK_delay;
wire JTGC405TDI_delay;
wire JTGC405TMS_delay;
wire JTGC405TRSTNEG_delay;
wire MCBCPUCLKEN_delay;
wire MCBJTAGEN_delay;
wire MCBTIMEREN_delay;
wire MCPPCRST_delay;
wire PLBC405DCUADDRACK_delay;
wire PLBC405DCUBUSY_delay;
wire PLBC405DCUERR_delay;
wire PLBC405DCURDDACK_delay;
wire PLBC405DCUSSIZE1_delay;
wire PLBC405DCUWRDACK_delay;
wire PLBC405ICUADDRACK_delay;
wire PLBC405ICUBUSY_delay;
wire PLBC405ICUERR_delay;
wire PLBC405ICURDDACK_delay;
wire PLBC405ICUSSIZE1_delay;
wire PLBCLK_delay;
wire RSTC405RESETCHIP_delay;
wire RSTC405RESETCORE_delay;
wire RSTC405RESETSYS_delay;
wire TIEC405DETERMINISTICMULT_delay;
wire TIEC405DISOPERANDFWD_delay;
wire TIEC405MMUEN_delay;
wire TIEPVRBIT10_delay;
wire TIEPVRBIT11_delay;
wire TIEPVRBIT28_delay;
wire TIEPVRBIT29_delay;
wire TIEPVRBIT30_delay;
wire TIEPVRBIT31_delay;
wire TIEPVRBIT8_delay;
wire TIEPVRBIT9_delay;
wire TRCC405TRACEDISABLE_delay;
wire TRCC405TRIGGEREVENTIN_delay;
wire [0:10] C405TRCTRIGGEREVENTTYPE_delay;
wire [0:15] TIEAPUCONTROL_delay;
wire [0:1] C405PLBDCUPRIORITY_delay;
wire [0:1] C405PLBICUPRIORITY_delay;
wire [0:1] C405TRCEVENEXECUTIONSTATUS_delay;
wire [0:1] C405TRCODDEXECUTIONSTATUS_delay;
wire [0:23] TIEAPUUDI1_delay;
wire [0:23] TIEAPUUDI2_delay;
wire [0:23] TIEAPUUDI3_delay;
wire [0:23] TIEAPUUDI4_delay;
wire [0:23] TIEAPUUDI5_delay;
wire [0:23] TIEAPUUDI6_delay;
wire [0:23] TIEAPUUDI7_delay;
wire [0:23] TIEAPUUDI8_delay;
wire [0:29] C405DBGWBIAR_delay;
wire [0:29] C405PLBICUABUS_delay;
wire [0:2] APUFCMDECUDI_delay;
wire [0:2] FCMAPUEXECRFIELD_delay;
wire [0:31] APUFCMINSTRUCTION_delay;
wire [0:31] APUFCMLOADDATA_delay;
wire [0:31] APUFCMRADATA_delay;
wire [0:31] APUFCMRBDATA_delay;
wire [0:31] BRAMDSOCMRDDBUS_delay;
wire [0:31] BRAMISOCMDCRRDDBUS_delay;
wire [0:31] C405PLBDCUABUS_delay;
wire [0:31] DCREMACDBUS_delay;
wire [0:31] DSOCMBRAMWRDBUS_delay;
wire [0:31] EMACDCRDBUS_delay;
wire [0:31] EXTDCRDBUSIN_delay;
wire [0:31] EXTDCRDBUSOUT_delay;
wire [0:31] FCMAPURESULT_delay;
wire [0:31] ISOCMBRAMWRDBUS_delay;
wire [0:3] APUFCMLOADBYTEEN_delay;
wire [0:3] C405TRCTRACESTATUS_delay;
wire [0:3] DSOCMBRAMBYTEWRITE_delay;
wire [0:3] FCMAPUCR_delay;
wire [0:5] TIEDCRADDR_delay;
wire [0:63] BRAMISOCMRDDBUS_delay;
wire [0:63] C405PLBDCUWRDBUS_delay;
wire [0:63] PLBC405DCURDDBUS_delay;
wire [0:63] PLBC405ICURDDBUS_delay;
wire [0:7] C405PLBDCUBE_delay;
wire [0:7] DSARCVALUE_delay;
wire [0:7] DSCNTLVALUE_delay;
wire [0:7] ISARCVALUE_delay;
wire [0:7] ISCNTLVALUE_delay;
wire [0:9] EXTDCRABUS_delay;
wire [1:3] PLBC405DCURDWDADDR_delay;
wire [1:3] PLBC405ICURDWDADDR_delay;
wire [2:3] C405PLBICUSIZE_delay;
wire [8:28] ISOCMBRAMRDABUS_delay;
wire [8:28] ISOCMBRAMWRABUS_delay;
wire [8:29] DSOCMBRAMABUS_delay;
wire [8:9] DCREMACABUS_delay;

wire BRAMDSOCMCLK_delay_1;
wire BRAMISOCMCLK_delay_1;
wire CPMC405CLOCK_delay_1;
wire CPMC405CORECLKINACTIVE_delay_1;
wire CPMC405CPUCLKEN_delay_1;
wire CPMC405JTAGCLKEN_delay_1;
wire CPMC405SYNCBYPASS_delay_1;
wire CPMC405TIMERCLKEN_delay_1;
wire CPMC405TIMERTICK_delay_1;
wire CPMDCRCLK_delay_1;
wire CPMFCMCLK_delay_1;
wire DBGC405DEBUGHALT_delay_1;
wire DBGC405EXTBUSHOLDACK_delay_1;
wire DBGC405UNCONDDEBUGEVENT_delay_1;
wire DSOCMRWCOMPLETE_delay_1;
wire EICC405CRITINPUTIRQ_delay_1;
wire EICC405EXTINPUTIRQ_delay_1;
wire EMACDCRACK_delay_1;
wire EXTDCRACK_delay_1;
wire FCMAPUDCDCREN_delay_1;
wire FCMAPUDCDFORCEALIGN_delay_1;
wire FCMAPUDCDFORCEBESTEERING_delay_1;
wire FCMAPUDCDFPUOP_delay_1;
wire FCMAPUDCDGPRWRITE_delay_1;
wire FCMAPUDCDLDSTBYTE_delay_1;
wire FCMAPUDCDLDSTDW_delay_1;
wire FCMAPUDCDLDSTHW_delay_1;
wire FCMAPUDCDLDSTQW_delay_1;
wire FCMAPUDCDLDSTWD_delay_1;
wire FCMAPUDCDLOAD_delay_1;
wire FCMAPUDCDPRIVOP_delay_1;
wire FCMAPUDCDRAEN_delay_1;
wire FCMAPUDCDRBEN_delay_1;
wire FCMAPUDCDSTORE_delay_1;
wire FCMAPUDCDTRAPBE_delay_1;
wire FCMAPUDCDTRAPLE_delay_1;
wire FCMAPUDCDUPDATE_delay_1;
wire FCMAPUDCDXERCAEN_delay_1;
wire FCMAPUDCDXEROVEN_delay_1;
wire FCMAPUDECODEBUSY_delay_1;
wire FCMAPUDONE_delay_1;
wire FCMAPUEXCEPTION_delay_1;
wire FCMAPUEXEBLOCKINGMCO_delay_1;
wire FCMAPUEXENONBLOCKINGMCO_delay_1;
wire FCMAPUINSTRACK_delay_1;
wire FCMAPULOADWAIT_delay_1;
wire FCMAPURESULTVALID_delay_1;
wire FCMAPUSLEEPNOTREADY_delay_1;
wire FCMAPUXERCA_delay_1;
wire FCMAPUXEROV_delay_1;
wire JTGC405BNDSCANTDO_delay_1;
wire JTGC405TCK_delay_1;
wire JTGC405TDI_delay_1;
wire JTGC405TMS_delay_1;
wire JTGC405TRSTNEG_delay_1;
wire MCBCPUCLKEN_delay_1;
wire MCBJTAGEN_delay_1;
wire MCBTIMEREN_delay_1;
wire MCPPCRST_delay_1;
wire PLBC405DCUADDRACK_delay_1;
wire PLBC405DCUBUSY_delay_1;
wire PLBC405DCUERR_delay_1;
wire PLBC405DCURDDACK_delay_1;
wire PLBC405DCUSSIZE1_delay_1;
wire PLBC405DCUWRDACK_delay_1;
wire PLBC405ICUADDRACK_delay_1;
wire PLBC405ICUBUSY_delay_1;
wire PLBC405ICUERR_delay_1;
wire PLBC405ICURDDACK_delay_1;
wire PLBC405ICUSSIZE1_delay_1;
wire PLBCLK_delay_1;
wire RSTC405RESETCHIP_delay_1;
wire RSTC405RESETCORE_delay_1;
wire RSTC405RESETSYS_delay_1;
wire TIEC405DETERMINISTICMULT_delay_1;
wire TIEC405DISOPERANDFWD_delay_1;
wire TIEC405MMUEN_delay_1;
wire TIEPVRBIT10_delay_1;
wire TIEPVRBIT11_delay_1;
wire TIEPVRBIT28_delay_1;
wire TIEPVRBIT29_delay_1;
wire TIEPVRBIT30_delay_1;
wire TIEPVRBIT31_delay_1;
wire TIEPVRBIT8_delay_1;
wire TIEPVRBIT9_delay_1;
wire TRCC405TRACEDISABLE_delay_1;
wire TRCC405TRIGGEREVENTIN_delay_1;
wire [0:15] TIEAPUCONTROL_delay_1;
wire [0:23] TIEAPUUDI1_delay_1;
wire [0:23] TIEAPUUDI2_delay_1;
wire [0:23] TIEAPUUDI3_delay_1;
wire [0:23] TIEAPUUDI4_delay_1;
wire [0:23] TIEAPUUDI5_delay_1;
wire [0:23] TIEAPUUDI6_delay_1;
wire [0:23] TIEAPUUDI7_delay_1;
wire [0:23] TIEAPUUDI8_delay_1;
wire [0:2] FCMAPUEXECRFIELD_delay_1;
wire [0:31] BRAMDSOCMRDDBUS_delay_1;
wire [0:31] BRAMISOCMDCRRDDBUS_delay_1;
wire [0:31] EMACDCRDBUS_delay_1;
wire [0:31] EXTDCRDBUSIN_delay_1;
wire [0:31] FCMAPURESULT_delay_1;
wire [0:3] FCMAPUCR_delay_1;
wire [0:5] TIEDCRADDR_delay_1;
wire [0:63] BRAMISOCMRDDBUS_delay_1;
wire [0:63] PLBC405DCURDDBUS_delay_1;
wire [0:63] PLBC405ICURDDBUS_delay_1;
wire [0:7] DSARCVALUE_delay_1;
wire [0:7] DSCNTLVALUE_delay_1;
wire [0:7] ISARCVALUE_delay_1;
wire [0:7] ISCNTLVALUE_delay_1;
wire [1:3] PLBC405DCURDWDADDR_delay_1;
wire [1:3] PLBC405ICURDWDADDR_delay_1;


assign #0 EMACDCRACK_delay = EMACDCRACK;
assign #0 EMACDCRDBUS_delay[0:31] = EMACDCRDBUS[0:31];
assign #0 BRAMDSOCMRDDBUS_delay[0:31] = BRAMDSOCMRDDBUS[0:31];
assign #0 DSOCMRWCOMPLETE_delay = DSOCMRWCOMPLETE;
assign #0 BRAMISOCMRDDBUS_delay[0:63] = BRAMISOCMRDDBUS[0:63];
assign #0 BRAMISOCMDCRRDDBUS_delay[0:31] = BRAMISOCMDCRRDDBUS[0:31];
assign #0 CPMC405CORECLKINACTIVE_delay = CPMC405CORECLKINACTIVE;
assign #0 CPMC405CPUCLKEN_delay = CPMC405CPUCLKEN;
assign #0 CPMC405JTAGCLKEN_delay = CPMC405JTAGCLKEN;
assign #0 CPMC405TIMERCLKEN_delay = CPMC405TIMERCLKEN;
assign #0 CPMC405SYNCBYPASS_delay = CPMC405SYNCBYPASS;
assign #0 CPMC405TIMERTICK_delay = CPMC405TIMERTICK;
assign #0 DBGC405DEBUGHALT_delay = DBGC405DEBUGHALT;
assign #0 DBGC405EXTBUSHOLDACK_delay = DBGC405EXTBUSHOLDACK;
assign #0 DBGC405UNCONDDEBUGEVENT_delay = DBGC405UNCONDDEBUGEVENT;
assign #0 EXTDCRACK_delay = EXTDCRACK;
assign #0 EXTDCRDBUSIN_delay[0:31] = EXTDCRDBUSIN[0:31];
assign #0 DSARCVALUE_delay[0:7] = DSARCVALUE[0:7];
assign #0 DSCNTLVALUE_delay[0:7] = DSCNTLVALUE[0:7];
assign #0 EICC405CRITINPUTIRQ_delay = EICC405CRITINPUTIRQ;
assign #0 EICC405EXTINPUTIRQ_delay = EICC405EXTINPUTIRQ;
assign #0 ISARCVALUE_delay[0:7] = ISARCVALUE[0:7];
assign #0 ISCNTLVALUE_delay[0:7] = ISCNTLVALUE[0:7];
assign #0 JTGC405BNDSCANTDO_delay = JTGC405BNDSCANTDO;
assign #0 JTGC405TCK_delay = JTGC405TCK;
assign #0 JTGC405TDI_delay = JTGC405TDI;
assign #0 JTGC405TMS_delay = JTGC405TMS;
assign #0 JTGC405TRSTNEG_delay = JTGC405TRSTNEG;
assign #0 MCBCPUCLKEN_delay = MCBCPUCLKEN;
assign #0 MCBJTAGEN_delay = MCBJTAGEN;
assign #0 MCBTIMEREN_delay = MCBTIMEREN;
assign #0 MCPPCRST_delay = MCPPCRST;
assign #0 PLBC405DCUADDRACK_delay = PLBC405DCUADDRACK;
assign #0 PLBC405DCUBUSY_delay = PLBC405DCUBUSY;
assign #0 PLBC405DCUERR_delay = PLBC405DCUERR;
assign #0 PLBC405DCURDDACK_delay = PLBC405DCURDDACK;
assign #0 PLBC405DCURDDBUS_delay[0:63] = PLBC405DCURDDBUS[0:63];
assign #0 PLBC405DCURDWDADDR_delay[1:3] = PLBC405DCURDWDADDR[1:3];
assign #0 PLBC405DCUSSIZE1_delay = PLBC405DCUSSIZE1;
assign #0 PLBC405DCUWRDACK_delay = PLBC405DCUWRDACK;
assign #0 PLBC405ICUADDRACK_delay = PLBC405ICUADDRACK;
assign #0 PLBC405ICUBUSY_delay = PLBC405ICUBUSY;
assign #0 PLBC405ICUERR_delay = PLBC405ICUERR;
assign #0 PLBC405ICURDDACK_delay = PLBC405ICURDDACK;
assign #0 PLBC405ICURDDBUS_delay[0:63] = PLBC405ICURDDBUS[0:63];
assign #0 PLBC405ICURDWDADDR_delay[1:3] = PLBC405ICURDWDADDR[1:3];
assign #0 PLBC405ICUSSIZE1_delay = PLBC405ICUSSIZE1;
assign #0 RSTC405RESETCHIP_delay = RSTC405RESETCHIP;
assign #0 RSTC405RESETCORE_delay = RSTC405RESETCORE;
assign #0 RSTC405RESETSYS_delay = RSTC405RESETSYS;
assign #0 TIEC405DETERMINISTICMULT_delay = TIEC405DETERMINISTICMULT;
assign #0 TIEC405DISOPERANDFWD_delay = TIEC405DISOPERANDFWD;
assign #0 TIEC405MMUEN_delay = TIEC405MMUEN;
assign #0 TIEDCRADDR_delay[0:5] = TIEDCRADDR[0:5];
assign #0 TRCC405TRACEDISABLE_delay = TRCC405TRACEDISABLE;
assign #0 TRCC405TRIGGEREVENTIN_delay = TRCC405TRIGGEREVENTIN;
assign #0 FCMAPURESULT_delay[0:31] = FCMAPURESULT[0:31];
assign #0 FCMAPUCR_delay[0:3] = FCMAPUCR[0:3];
assign #0 FCMAPUEXECRFIELD_delay[0:2] = FCMAPUEXECRFIELD[0:2];
assign #0 FCMAPUDONE_delay = FCMAPUDONE;
assign #0 FCMAPURESULTVALID_delay = FCMAPURESULTVALID;
assign #0 FCMAPUINSTRACK_delay = FCMAPUINSTRACK;
assign #0 FCMAPUEXCEPTION_delay = FCMAPUEXCEPTION;
assign #0 FCMAPUXERCA_delay = FCMAPUXERCA;
assign #0 FCMAPUXEROV_delay = FCMAPUXEROV;
assign #0 FCMAPUDCDFPUOP_delay = FCMAPUDCDFPUOP;
assign #0 FCMAPUDCDGPRWRITE_delay = FCMAPUDCDGPRWRITE;
assign #0 FCMAPUDCDRAEN_delay = FCMAPUDCDRAEN;
assign #0 FCMAPUDCDRBEN_delay = FCMAPUDCDRBEN;
assign #0 FCMAPUDCDLOAD_delay = FCMAPUDCDLOAD;
assign #0 FCMAPUDCDSTORE_delay = FCMAPUDCDSTORE;
assign #0 FCMAPUDCDXERCAEN_delay = FCMAPUDCDXERCAEN;
assign #0 FCMAPUDCDXEROVEN_delay = FCMAPUDCDXEROVEN;
assign #0 FCMAPUDCDPRIVOP_delay = FCMAPUDCDPRIVOP;
assign #0 FCMAPUDCDCREN_delay = FCMAPUDCDCREN;
assign #0 FCMAPUDCDUPDATE_delay = FCMAPUDCDUPDATE;
assign #0 FCMAPUDCDFORCEALIGN_delay = FCMAPUDCDFORCEALIGN;
assign #0 FCMAPUDCDFORCEBESTEERING_delay = FCMAPUDCDFORCEBESTEERING;
assign #0 FCMAPUDCDLDSTBYTE_delay = FCMAPUDCDLDSTBYTE;
assign #0 FCMAPUDCDLDSTHW_delay = FCMAPUDCDLDSTHW;
assign #0 FCMAPUDCDLDSTWD_delay = FCMAPUDCDLDSTWD;
assign #0 FCMAPUDCDLDSTDW_delay = FCMAPUDCDLDSTDW;
assign #0 FCMAPUDCDLDSTQW_delay = FCMAPUDCDLDSTQW;
assign #0 FCMAPUDCDTRAPBE_delay = FCMAPUDCDTRAPBE;
assign #0 FCMAPUDCDTRAPLE_delay = FCMAPUDCDTRAPLE;
assign #0 FCMAPUEXEBLOCKINGMCO_delay = FCMAPUEXEBLOCKINGMCO;
assign #0 FCMAPUEXENONBLOCKINGMCO_delay = FCMAPUEXENONBLOCKINGMCO;
assign #0 FCMAPUSLEEPNOTREADY_delay = FCMAPUSLEEPNOTREADY;
assign #0 FCMAPULOADWAIT_delay = FCMAPULOADWAIT;
assign #0 FCMAPUDECODEBUSY_delay = FCMAPUDECODEBUSY;
assign #0 TIEAPUCONTROL_delay[0:15] = TIEAPUCONTROL[0:15];
assign #0 TIEAPUUDI1_delay[0:23] = TIEAPUUDI1[0:23];
assign #0 TIEAPUUDI2_delay[0:23] = TIEAPUUDI2[0:23];
assign #0 TIEAPUUDI3_delay[0:23] = TIEAPUUDI3[0:23];
assign #0 TIEAPUUDI4_delay[0:23] = TIEAPUUDI4[0:23];
assign #0 TIEAPUUDI5_delay[0:23] = TIEAPUUDI5[0:23];
assign #0 TIEAPUUDI6_delay[0:23] = TIEAPUUDI6[0:23];
assign #0 TIEAPUUDI7_delay[0:23] = TIEAPUUDI7[0:23];
assign #0 TIEAPUUDI8_delay[0:23] = TIEAPUUDI8[0:23];


assign #0 DCREMACABUS[8:9] = DCREMACABUS_delay[8:9];
assign #0 DCREMACDBUS[0:31] = DCREMACDBUS_delay[0:31];
assign #0 DCREMACENABLER = DCREMACENABLER_delay;
assign #0 DCREMACREAD = DCREMACREAD_delay;
assign #0 DCREMACWRITE = DCREMACWRITE_delay;

assign #(out_delay) C405CPMCORESLEEPREQ = C405CPMCORESLEEPREQ_delay;
assign #(out_delay) C405CPMMSRCE = C405CPMMSRCE_delay;
assign #(out_delay) C405CPMMSREE = C405CPMMSREE_delay;
assign #(out_delay) C405CPMTIMERIRQ = C405CPMTIMERIRQ_delay;
assign #(out_delay) C405CPMTIMERRESETREQ = C405CPMTIMERRESETREQ_delay;
assign #(out_delay) C405DBGMSRWE = C405DBGMSRWE_delay;
assign #(out_delay) C405DBGSTOPACK = C405DBGSTOPACK_delay;
assign #(out_delay) C405DBGWBCOMPLETE = C405DBGWBCOMPLETE_delay;
assign #(out_delay) C405DBGWBFULL = C405DBGWBFULL_delay;
assign #(out_delay) C405DBGWBIAR[0:29] = C405DBGWBIAR_delay[0:29];
assign #(out_delay) EXTDCRABUS[0:9] = EXTDCRABUS_delay[0:9];
assign #(out_delay) EXTDCRDBUSOUT[0:31] = EXTDCRDBUSOUT_delay[0:31];
assign #(out_delay) EXTDCRREAD = EXTDCRREAD_delay;
assign #(out_delay) EXTDCRWRITE = EXTDCRWRITE_delay;
assign #(out_delay) C405JTGCAPTUREDR = C405JTGCAPTUREDR_delay;
assign #(out_delay) C405JTGEXTEST = C405JTGEXTEST_delay;
assign #(out_delay) C405JTGPGMOUT = C405JTGPGMOUT_delay;
assign #(out_delay) C405JTGSHIFTDR = C405JTGSHIFTDR_delay;
assign #(out_delay) C405JTGTDO = C405JTGTDO_delay;
assign #(out_delay) C405JTGTDOEN = C405JTGTDOEN_delay;
assign #(out_delay) C405JTGUPDATEDR = C405JTGUPDATEDR_delay;
assign #(out_delay) C405PLBDCUABORT = C405PLBDCUABORT_delay;
assign #(out_delay) C405PLBDCUABUS[0:31] = C405PLBDCUABUS_delay[0:31];
assign #(out_delay) C405PLBDCUBE[0:7] = C405PLBDCUBE_delay[0:7];
assign #(out_delay) C405PLBDCUCACHEABLE = C405PLBDCUCACHEABLE_delay;
assign #(out_delay) C405PLBDCUGUARDED = C405PLBDCUGUARDED_delay;
assign #(out_delay) C405PLBDCUPRIORITY[0:1] = C405PLBDCUPRIORITY_delay[0:1];
assign #(out_delay) C405PLBDCUREQUEST = C405PLBDCUREQUEST_delay;
assign #(out_delay) C405PLBDCURNW = C405PLBDCURNW_delay;
assign #(out_delay) C405PLBDCUSIZE2 = C405PLBDCUSIZE2_delay;
assign #(out_delay) C405PLBDCUU0ATTR = C405PLBDCUU0ATTR_delay;
assign #(out_delay) C405PLBDCUWRDBUS[0:63] = C405PLBDCUWRDBUS_delay[0:63];
assign #(out_delay) C405PLBDCUWRITETHRU = C405PLBDCUWRITETHRU_delay;
assign #(out_delay) C405PLBICUABORT = C405PLBICUABORT_delay;
assign #(out_delay) C405PLBICUABUS[0:29] = C405PLBICUABUS_delay[0:29];
assign #(out_delay) C405PLBICUCACHEABLE = C405PLBICUCACHEABLE_delay;
assign #(out_delay) C405PLBICUPRIORITY[0:1] = C405PLBICUPRIORITY_delay[0:1];
assign #(out_delay) C405PLBICUREQUEST = C405PLBICUREQUEST_delay;
assign #(out_delay) C405PLBICUSIZE[2:3] = C405PLBICUSIZE_delay[2:3];
assign #(out_delay) C405PLBICUU0ATTR = C405PLBICUU0ATTR_delay;
assign #(out_delay) C405RSTCHIPRESETREQ = C405RSTCHIPRESETREQ_delay;
assign #(out_delay) C405RSTCORERESETREQ = C405RSTCORERESETREQ_delay;
assign #(out_delay) C405RSTSYSRESETREQ = C405RSTSYSRESETREQ_delay;
assign #(out_delay) C405TRCCYCLE = C405TRCCYCLE_delay;
assign #(out_delay) C405TRCEVENEXECUTIONSTATUS[0:1] = C405TRCEVENEXECUTIONSTATUS_delay[0:1];
assign #(out_delay) C405TRCODDEXECUTIONSTATUS[0:1] = C405TRCODDEXECUTIONSTATUS_delay[0:1];
assign #(out_delay) C405TRCTRACESTATUS[0:3] = C405TRCTRACESTATUS_delay[0:3];
assign #(out_delay) C405TRCTRIGGEREVENTOUT = C405TRCTRIGGEREVENTOUT_delay;
assign #(out_delay) C405TRCTRIGGEREVENTTYPE[0:10] = C405TRCTRIGGEREVENTTYPE_delay[0:10];
assign #(out_delay) C405XXXMACHINECHECK = C405XXXMACHINECHECK_delay;
assign #(out_delay) DSOCMBRAMABUS[8:29] = DSOCMBRAMABUS_delay[8:29];
assign #(out_delay) DSOCMBRAMBYTEWRITE[0:3] = DSOCMBRAMBYTEWRITE_delay[0:3];
assign #(out_delay) DSOCMBRAMEN = DSOCMBRAMEN_delay;
assign #(out_delay) DSOCMBRAMWRDBUS[0:31] = DSOCMBRAMWRDBUS_delay[0:31];
assign #(out_delay) DSOCMBUSY = DSOCMBUSY_delay;
assign #(out_delay) DSOCMWRADDRVALID = DSOCMWRADDRVALID_delay;
assign #(out_delay) DSOCMRDADDRVALID = DSOCMRDADDRVALID_delay;
assign #(out_delay) ISOCMBRAMEN = ISOCMBRAMEN_delay;
assign #(out_delay) ISOCMBRAMEVENWRITEEN = ISOCMBRAMEVENWRITEEN_delay;
assign #(out_delay) ISOCMBRAMODDWRITEEN = ISOCMBRAMODDWRITEEN_delay;
assign #(out_delay) ISOCMDCRBRAMEVENEN = ISOCMDCRBRAMEVENEN_delay;
assign #(out_delay) ISOCMDCRBRAMODDEN = ISOCMDCRBRAMODDEN_delay;
assign #(out_delay) ISOCMDCRBRAMRDSELECT = ISOCMDCRBRAMRDSELECT_delay;
assign #(out_delay) ISOCMBRAMRDABUS[8:28] = ISOCMBRAMRDABUS_delay[8:28];
assign #(out_delay) ISOCMBRAMWRABUS[8:28] = ISOCMBRAMWRABUS_delay[8:28];
assign #(out_delay) ISOCMBRAMWRDBUS[0:31] = ISOCMBRAMWRDBUS_delay[0:31];
assign #(out_delay) C405DBGLOADDATAONAPUDBUS = C405DBGLOADDATAONAPUDBUS_delay;
assign #(out_delay) APUFCMINSTRUCTION[0:31] = APUFCMINSTRUCTION_delay[0:31];
assign #(out_delay) APUFCMRADATA[0:31] = APUFCMRADATA_delay[0:31];
assign #(out_delay) APUFCMRBDATA[0:31] = APUFCMRBDATA_delay[0:31];
assign #(out_delay) APUFCMLOADDATA[0:31] = APUFCMLOADDATA_delay[0:31];
assign #(out_delay) APUFCMLOADBYTEEN[0:3] = APUFCMLOADBYTEEN_delay[0:3];
assign #(out_delay) APUFCMINSTRVALID = APUFCMINSTRVALID_delay;
assign #(out_delay) APUFCMOPERANDVALID = APUFCMOPERANDVALID_delay;
assign #(out_delay) APUFCMLOADDVALID = APUFCMLOADDVALID_delay;
assign #(out_delay) APUFCMFLUSH = APUFCMFLUSH_delay;
assign #(out_delay) APUFCMWRITEBACKOK = APUFCMWRITEBACKOK_delay;
assign #(out_delay) APUFCMENDIAN = APUFCMENDIAN_delay;
assign #(out_delay) APUFCMXERCA = APUFCMXERCA_delay;
assign #(out_delay) APUFCMDECODED = APUFCMDECODED_delay;
assign #(out_delay) APUFCMDECUDI[0:2] = APUFCMDECUDI_delay[0:2];
assign #(out_delay) APUFCMDECUDIVALID = APUFCMDECUDIVALID_delay;

assign #(in_delay) BRAMDSOCMCLK_delay_1 = BRAMDSOCMCLK_delay;
assign #(in_delay) BRAMISOCMCLK_delay_1 = BRAMISOCMCLK_delay;
assign #(in_delay) CPMC405CLOCK_delay_1 = CPMC405CLOCK_delay;
assign #(in_delay) CPMC405CORECLKINACTIVE_delay_1 = CPMC405CORECLKINACTIVE_delay;
assign #(in_delay) CPMC405CPUCLKEN_delay_1 = CPMC405CPUCLKEN_delay;
assign #(in_delay) CPMC405JTAGCLKEN_delay_1 = CPMC405JTAGCLKEN_delay;
assign #(in_delay) CPMC405SYNCBYPASS_delay_1 = CPMC405SYNCBYPASS_delay;
assign #(in_delay) CPMC405TIMERCLKEN_delay_1 = CPMC405TIMERCLKEN_delay;
assign #(in_delay) CPMC405TIMERTICK_delay_1 = CPMC405TIMERTICK_delay;
assign #(in_delay) CPMDCRCLK_delay_1 = CPMDCRCLK_delay;
assign #(in_delay) CPMFCMCLK_delay_1 = CPMFCMCLK_delay;
assign #(in_delay) DBGC405DEBUGHALT_delay_1 = DBGC405DEBUGHALT_delay;
assign #(in_delay) DBGC405EXTBUSHOLDACK_delay_1 = DBGC405EXTBUSHOLDACK_delay;
assign #(in_delay) DBGC405UNCONDDEBUGEVENT_delay_1 = DBGC405UNCONDDEBUGEVENT_delay;
assign #(in_delay) DSOCMRWCOMPLETE_delay_1 = DSOCMRWCOMPLETE_delay;
assign #(in_delay) EICC405CRITINPUTIRQ_delay_1 = EICC405CRITINPUTIRQ_delay;
assign #(in_delay) EICC405EXTINPUTIRQ_delay_1 = EICC405EXTINPUTIRQ_delay;
assign #(in_delay) EMACDCRACK_delay_1 = EMACDCRACK_delay;
assign #(in_delay) EXTDCRACK_delay_1 = EXTDCRACK_delay;
assign #(in_delay) FCMAPUDCDCREN_delay_1 = FCMAPUDCDCREN_delay;
assign #(in_delay) FCMAPUDCDFORCEALIGN_delay_1 = FCMAPUDCDFORCEALIGN_delay;
assign #(in_delay) FCMAPUDCDFORCEBESTEERING_delay_1 = FCMAPUDCDFORCEBESTEERING_delay;
assign #(in_delay) FCMAPUDCDFPUOP_delay_1 = FCMAPUDCDFPUOP_delay;
assign #(in_delay) FCMAPUDCDGPRWRITE_delay_1 = FCMAPUDCDGPRWRITE_delay;
assign #(in_delay) FCMAPUDCDLDSTBYTE_delay_1 = FCMAPUDCDLDSTBYTE_delay;
assign #(in_delay) FCMAPUDCDLDSTDW_delay_1 = FCMAPUDCDLDSTDW_delay;
assign #(in_delay) FCMAPUDCDLDSTHW_delay_1 = FCMAPUDCDLDSTHW_delay;
assign #(in_delay) FCMAPUDCDLDSTQW_delay_1 = FCMAPUDCDLDSTQW_delay;
assign #(in_delay) FCMAPUDCDLDSTWD_delay_1 = FCMAPUDCDLDSTWD_delay;
assign #(in_delay) FCMAPUDCDLOAD_delay_1 = FCMAPUDCDLOAD_delay;
assign #(in_delay) FCMAPUDCDPRIVOP_delay_1 = FCMAPUDCDPRIVOP_delay;
assign #(in_delay) FCMAPUDCDRAEN_delay_1 = FCMAPUDCDRAEN_delay;
assign #(in_delay) FCMAPUDCDRBEN_delay_1 = FCMAPUDCDRBEN_delay;
assign #(in_delay) FCMAPUDCDSTORE_delay_1 = FCMAPUDCDSTORE_delay;
assign #(in_delay) FCMAPUDCDTRAPBE_delay_1 = FCMAPUDCDTRAPBE_delay;
assign #(in_delay) FCMAPUDCDTRAPLE_delay_1 = FCMAPUDCDTRAPLE_delay;
assign #(in_delay) FCMAPUDCDUPDATE_delay_1 = FCMAPUDCDUPDATE_delay;
assign #(in_delay) FCMAPUDCDXERCAEN_delay_1 = FCMAPUDCDXERCAEN_delay;
assign #(in_delay) FCMAPUDCDXEROVEN_delay_1 = FCMAPUDCDXEROVEN_delay;
assign #(in_delay) FCMAPUDECODEBUSY_delay_1 = FCMAPUDECODEBUSY_delay;
assign #(in_delay) FCMAPUDONE_delay_1 = FCMAPUDONE_delay;
assign #(in_delay) FCMAPUEXCEPTION_delay_1 = FCMAPUEXCEPTION_delay;
assign #(in_delay) FCMAPUEXEBLOCKINGMCO_delay_1 = FCMAPUEXEBLOCKINGMCO_delay;
assign #(in_delay) FCMAPUEXENONBLOCKINGMCO_delay_1 = FCMAPUEXENONBLOCKINGMCO_delay;
assign #(in_delay) FCMAPUINSTRACK_delay_1 = FCMAPUINSTRACK_delay;
assign #(in_delay) FCMAPULOADWAIT_delay_1 = FCMAPULOADWAIT_delay;
assign #(in_delay) FCMAPURESULTVALID_delay_1 = FCMAPURESULTVALID_delay;
assign #(in_delay) FCMAPUSLEEPNOTREADY_delay_1 = FCMAPUSLEEPNOTREADY_delay;
assign #(in_delay) FCMAPUXERCA_delay_1 = FCMAPUXERCA_delay;
assign #(in_delay) FCMAPUXEROV_delay_1 = FCMAPUXEROV_delay;
assign #(in_delay) JTGC405BNDSCANTDO_delay_1 = JTGC405BNDSCANTDO_delay;
assign #(in_delay) JTGC405TCK_delay_1 = JTGC405TCK_delay;
assign #(in_delay) JTGC405TDI_delay_1 = JTGC405TDI_delay;
assign #(in_delay) JTGC405TMS_delay_1 = JTGC405TMS_delay;
assign #(in_delay) JTGC405TRSTNEG_delay_1 = JTGC405TRSTNEG_delay;
assign #(in_delay) MCBCPUCLKEN_delay_1 = MCBCPUCLKEN_delay;
assign #(in_delay) MCBJTAGEN_delay_1 = MCBJTAGEN_delay;
assign #(in_delay) MCBTIMEREN_delay_1 = MCBTIMEREN_delay;
assign #(in_delay) MCPPCRST_delay_1 = MCPPCRST_delay;
assign #(in_delay) PLBC405DCUADDRACK_delay_1 = PLBC405DCUADDRACK_delay;
assign #(in_delay) PLBC405DCUBUSY_delay_1 = PLBC405DCUBUSY_delay;
assign #(in_delay) PLBC405DCUERR_delay_1 = PLBC405DCUERR_delay;
assign #(in_delay) PLBC405DCURDDACK_delay_1 = PLBC405DCURDDACK_delay;
assign #(in_delay) PLBC405DCUSSIZE1_delay_1 = PLBC405DCUSSIZE1_delay;
assign #(in_delay) PLBC405DCUWRDACK_delay_1 = PLBC405DCUWRDACK_delay;
assign #(in_delay) PLBC405ICUADDRACK_delay_1 = PLBC405ICUADDRACK_delay;
assign #(in_delay) PLBC405ICUBUSY_delay_1 = PLBC405ICUBUSY_delay;
assign #(in_delay) PLBC405ICUERR_delay_1 = PLBC405ICUERR_delay;
assign #(in_delay) PLBC405ICURDDACK_delay_1 = PLBC405ICURDDACK_delay;
assign #(in_delay) PLBC405ICUSSIZE1_delay_1 = PLBC405ICUSSIZE1_delay;
assign #(in_delay) PLBCLK_delay_1 = PLBCLK_delay;
assign #(in_delay) RSTC405RESETCHIP_delay_1 = RSTC405RESETCHIP_delay;
assign #(in_delay) RSTC405RESETCORE_delay_1 = RSTC405RESETCORE_delay;
assign #(in_delay) RSTC405RESETSYS_delay_1 = RSTC405RESETSYS_delay;
assign #(in_delay) TIEC405DETERMINISTICMULT_delay_1 = TIEC405DETERMINISTICMULT_delay;
assign #(in_delay) TIEC405DISOPERANDFWD_delay_1 = TIEC405DISOPERANDFWD_delay;
assign #(in_delay) TIEC405MMUEN_delay_1 = TIEC405MMUEN_delay;
assign #(in_delay) TIEPVRBIT10_delay_1 = TIEPVRBIT10_delay;
assign #(in_delay) TIEPVRBIT11_delay_1 = TIEPVRBIT11_delay;
assign #(in_delay) TIEPVRBIT28_delay_1 = TIEPVRBIT28_delay;
assign #(in_delay) TIEPVRBIT29_delay_1 = TIEPVRBIT29_delay;
assign #(in_delay) TIEPVRBIT30_delay_1 = TIEPVRBIT30_delay;
assign #(in_delay) TIEPVRBIT31_delay_1 = TIEPVRBIT31_delay;
assign #(in_delay) TIEPVRBIT8_delay_1 = TIEPVRBIT8_delay;
assign #(in_delay) TIEPVRBIT9_delay_1 = TIEPVRBIT9_delay;
assign #(in_delay) TRCC405TRACEDISABLE_delay_1 = TRCC405TRACEDISABLE_delay;
assign #(in_delay) TRCC405TRIGGEREVENTIN_delay_1 = TRCC405TRIGGEREVENTIN_delay;
assign #(in_delay) TIEAPUCONTROL_delay_1[0:15] = TIEAPUCONTROL_delay[0:15] ;
assign #(in_delay) TIEAPUUDI1_delay_1[0:23] = TIEAPUUDI1_delay[0:23];
assign #(in_delay) TIEAPUUDI2_delay_1[0:23] = TIEAPUUDI2_delay[0:23];
assign #(in_delay) TIEAPUUDI3_delay_1[0:23] = TIEAPUUDI3_delay[0:23];
assign #(in_delay) TIEAPUUDI4_delay_1[0:23] = TIEAPUUDI4_delay[0:23];
assign #(in_delay) TIEAPUUDI5_delay_1[0:23] = TIEAPUUDI5_delay[0:23];
assign #(in_delay) TIEAPUUDI6_delay_1[0:23] = TIEAPUUDI6_delay[0:23];
assign #(in_delay) TIEAPUUDI7_delay_1[0:23] = TIEAPUUDI7_delay[0:23];
assign #(in_delay) TIEAPUUDI8_delay_1[0:23] = TIEAPUUDI8_delay[0:23];
assign #(in_delay) FCMAPUEXECRFIELD_delay_1[0:2] = FCMAPUEXECRFIELD_delay[0:2] ;
assign #(in_delay) BRAMDSOCMRDDBUS_delay_1[0:31] = BRAMDSOCMRDDBUS_delay[0:31] ;
assign #(in_delay) BRAMISOCMDCRRDDBUS_delay_1[0:31] = BRAMISOCMDCRRDDBUS_delay[0:31] ;
assign #(in_delay) EMACDCRDBUS_delay_1[0:31] = EMACDCRDBUS_delay[0:31] ;
assign #(in_delay) EXTDCRDBUSIN_delay_1[0:31] = EXTDCRDBUSIN_delay[0:31] ;
assign #(in_delay) FCMAPURESULT_delay_1[0:31] = FCMAPURESULT_delay[0:31] ;
assign #(in_delay) FCMAPUCR_delay_1[0:3] = FCMAPUCR_delay[0:3] ;
assign #(in_delay) TIEDCRADDR_delay_1[0:5] = TIEDCRADDR_delay[0:5] ;
assign #(in_delay) BRAMISOCMRDDBUS_delay_1[0:63] = BRAMISOCMRDDBUS_delay[0:63] ;
assign #(in_delay) PLBC405DCURDDBUS_delay_1[0:63] = PLBC405DCURDDBUS_delay[0:63] ;
assign #(in_delay) PLBC405ICURDDBUS_delay_1[0:63] = PLBC405ICURDDBUS_delay[0:63] ;
assign #(in_delay) DSARCVALUE_delay_1[0:7] = DSARCVALUE_delay[0:7] ;
assign #(in_delay) DSCNTLVALUE_delay_1[0:7] = DSCNTLVALUE_delay[0:7] ;
assign #(in_delay) ISARCVALUE_delay_1[0:7] = ISARCVALUE_delay[0:7] ;
assign #(in_delay) ISCNTLVALUE_delay_1[0:7] = ISCNTLVALUE_delay[0:7] ;
assign #(in_delay) PLBC405DCURDWDADDR_delay_1[1:3] = PLBC405DCURDWDADDR_delay[1:3] ;
assign #(in_delay) PLBC405ICURDWDADDR_delay_1[1:3] = PLBC405ICURDWDADDR_delay[1:3] ;

wire	FPGA_CCLK;
wire	FPGA_BUS_RESET;
wire	FPGA_GSR;
wire	FPGA_GWE;
wire	FPGA_GHIGHB;
wire	GSR_OR;

reg	FPGA_POR;
reg	FPGA_CCLK_REG;

tri0	GSR = glbl.GSR;

`ifdef STARTUP_BLK
assign	FPGA_CCLK	= TESTBENCH.FPGA_cclk;
assign	FPGA_BUS_RESET	= TESTBENCH.FPGA_bus_reset;
assign	GSR_OR	= TESTBENCH.FPGA_gsr;
assign	FPGA_GWE	= TESTBENCH.FPGA_gwe;
assign	FPGA_GHIGHB	= TESTBENCH.FPGA_ghigh_b;
`else

FPGA_startup_VIRTEX4 start_blk(
	.bus_reset (FPGA_BUS_RESET),
	.ghigh_b (FPGA_GHIGHB),
	.gsr (FPGA_GSR),
	.done (),
	.gwe (FPGA_GWE),
	.gts_b (),
	.shutdown (1'b0),
	.cclk (FPGA_CCLK),
	.por (FPGA_POR)
);

or IGSR_OR (GSR_OR, FPGA_GSR, GSR);

`define Loc_FPGA_POR_TIME_VIRTEX4 1000 // FPGA Power-On Reset time

// Generate FPGA CCLK
always
	#5000 FPGA_CCLK_REG = ~FPGA_CCLK_REG;

assign	FPGA_CCLK = FPGA_CCLK_REG;

initial begin
	FPGA_CCLK_REG = 0;
	FPGA_POR = 1'b1;
	#(`Loc_FPGA_POR_TIME_VIRTEX4) FPGA_POR = 1'b0;
end

`endif // STARTUP_BLK

wire FPGA_BUS_RESET_delay;
wire GSR_delay;
wire FPGA_GWE_delay;
wire FPGA_GHIGHB_delay;

assign #0 FPGA_BUS_RESET_delay = FPGA_BUS_RESET;
assign #0 GSR_delay = GSR_OR;
assign #0 FPGA_GWE_delay = FPGA_GWE;
assign #0 FPGA_GHIGHB_delay = FPGA_GHIGHB;

//`ifdef PROCBLK_NOSWIFT
//usr_pblk_adv_cap Iusr_proc_block_cap(
//`else
PPC405_ADV_SWIFT IPPC405_SWIFT(
//`endif //PROCBLK_NOSWIFT

	.BUS_RESET (FPGA_BUS_RESET_delay),
	.GSR (GSR_delay),
	.GWE (FPGA_GWE_delay),
	.GHIGHB (FPGA_GHIGHB_delay),
	.CFG_MCLK (FPGA_CCLK),

        .APUFCMDECODED(APUFCMDECODED_delay),
        .APUFCMDECUDIVALID(APUFCMDECUDIVALID_delay),
        .APUFCMENDIAN(APUFCMENDIAN_delay),
        .APUFCMFLUSH(APUFCMFLUSH_delay),
        .APUFCMINSTRVALID(APUFCMINSTRVALID_delay),
        .APUFCMLOADDVALID(APUFCMLOADDVALID_delay),
        .APUFCMOPERANDVALID(APUFCMOPERANDVALID_delay),
        .APUFCMWRITEBACKOK(APUFCMWRITEBACKOK_delay),
        .APUFCMXERCA(APUFCMXERCA_delay),
        .C405CPMCORESLEEPREQ(C405CPMCORESLEEPREQ_delay),
        .C405CPMMSRCE(C405CPMMSRCE_delay),
        .C405CPMMSREE(C405CPMMSREE_delay),
        .C405CPMTIMERIRQ(C405CPMTIMERIRQ_delay),
        .C405CPMTIMERRESETREQ(C405CPMTIMERRESETREQ_delay),
        .C405DBGLOADDATAONAPUDBUS(C405DBGLOADDATAONAPUDBUS_delay),
        .C405DBGMSRWE(C405DBGMSRWE_delay),
        .C405DBGSTOPACK(C405DBGSTOPACK_delay),
        .C405DBGWBCOMPLETE(C405DBGWBCOMPLETE_delay),
        .C405DBGWBFULL(C405DBGWBFULL_delay),
        .C405JTGCAPTUREDR(C405JTGCAPTUREDR_delay),
        .C405JTGEXTEST(C405JTGEXTEST_delay),
        .C405JTGPGMOUT(C405JTGPGMOUT_delay),
        .C405JTGSHIFTDR(C405JTGSHIFTDR_delay),
        .C405JTGTDO(C405JTGTDO_delay),
        .C405JTGTDOEN(C405JTGTDOEN_delay),
        .C405JTGUPDATEDR(C405JTGUPDATEDR_delay),
        .C405PLBDCUABORT(C405PLBDCUABORT_delay),
        .C405PLBDCUCACHEABLE(C405PLBDCUCACHEABLE_delay),
        .C405PLBDCUGUARDED(C405PLBDCUGUARDED_delay),
        .C405PLBDCUREQUEST(C405PLBDCUREQUEST_delay),
        .C405PLBDCURNW(C405PLBDCURNW_delay),
        .C405PLBDCUSIZE2(C405PLBDCUSIZE2_delay),
        .C405PLBDCUU0ATTR(C405PLBDCUU0ATTR_delay),
        .C405PLBDCUWRITETHRU(C405PLBDCUWRITETHRU_delay),
        .C405PLBICUABORT(C405PLBICUABORT_delay),
        .C405PLBICUCACHEABLE(C405PLBICUCACHEABLE_delay),
        .C405PLBICUREQUEST(C405PLBICUREQUEST_delay),
        .C405PLBICUU0ATTR(C405PLBICUU0ATTR_delay),
        .C405RSTCHIPRESETREQ(C405RSTCHIPRESETREQ_delay),
        .C405RSTCORERESETREQ(C405RSTCORERESETREQ_delay),
        .C405RSTSYSRESETREQ(C405RSTSYSRESETREQ_delay),
        .C405TRCCYCLE(C405TRCCYCLE_delay),
        .C405TRCTRIGGEREVENTOUT(C405TRCTRIGGEREVENTOUT_delay),
        .C405XXXMACHINECHECK(C405XXXMACHINECHECK_delay),
        .DCREMACCLK(DCREMACCLK),
        .DCREMACENABLER(DCREMACENABLER_delay),
        .DCREMACREAD(DCREMACREAD_delay),
        .DCREMACWRITE(DCREMACWRITE_delay),
        .DSOCMBRAMEN(DSOCMBRAMEN_delay),
        .DSOCMBUSY(DSOCMBUSY_delay),
        .DSOCMRDADDRVALID(DSOCMRDADDRVALID_delay),
        .DSOCMWRADDRVALID(DSOCMWRADDRVALID_delay),
        .EXTDCRREAD(EXTDCRREAD_delay),
        .EXTDCRWRITE(EXTDCRWRITE_delay),
        .ISOCMBRAMEN(ISOCMBRAMEN_delay),
        .ISOCMBRAMEVENWRITEEN(ISOCMBRAMEVENWRITEEN_delay),
        .ISOCMBRAMODDWRITEEN(ISOCMBRAMODDWRITEEN_delay),
        .ISOCMDCRBRAMEVENEN(ISOCMDCRBRAMEVENEN_delay),
        .ISOCMDCRBRAMODDEN(ISOCMDCRBRAMODDEN_delay),
        .ISOCMDCRBRAMRDSELECT(ISOCMDCRBRAMRDSELECT_delay),
        .C405TRCTRIGGEREVENTTYPE(C405TRCTRIGGEREVENTTYPE_delay),
        .C405PLBDCUPRIORITY(C405PLBDCUPRIORITY_delay),
        .C405PLBICUPRIORITY(C405PLBICUPRIORITY_delay),
        .C405TRCEVENEXECUTIONSTATUS(C405TRCEVENEXECUTIONSTATUS_delay),
        .C405TRCODDEXECUTIONSTATUS(C405TRCODDEXECUTIONSTATUS_delay),
        .C405DBGWBIAR(C405DBGWBIAR_delay),
        .C405PLBICUABUS(C405PLBICUABUS_delay),
        .APUFCMDECUDI(APUFCMDECUDI_delay),
        .APUFCMINSTRUCTION(APUFCMINSTRUCTION_delay),
        .APUFCMLOADDATA(APUFCMLOADDATA_delay),
        .APUFCMRADATA(APUFCMRADATA_delay),
        .APUFCMRBDATA(APUFCMRBDATA_delay),
        .C405PLBDCUABUS(C405PLBDCUABUS_delay),
        .DCREMACDBUS(DCREMACDBUS_delay),
        .DSOCMBRAMWRDBUS(DSOCMBRAMWRDBUS_delay),
        .EXTDCRDBUSOUT(EXTDCRDBUSOUT_delay),
        .ISOCMBRAMWRDBUS(ISOCMBRAMWRDBUS_delay),
        .APUFCMLOADBYTEEN(APUFCMLOADBYTEEN_delay),
        .C405TRCTRACESTATUS(C405TRCTRACESTATUS_delay),
        .DSOCMBRAMBYTEWRITE(DSOCMBRAMBYTEWRITE_delay),
        .C405PLBDCUWRDBUS(C405PLBDCUWRDBUS_delay),
        .C405PLBDCUBE(C405PLBDCUBE_delay),
        .EXTDCRABUS(EXTDCRABUS_delay),
        .C405PLBICUSIZE(C405PLBICUSIZE_delay),
        .ISOCMBRAMRDABUS(ISOCMBRAMRDABUS_delay),
        .ISOCMBRAMWRABUS(ISOCMBRAMWRABUS_delay),
        .DSOCMBRAMABUS(DSOCMBRAMABUS_delay),
        .DCREMACABUS(DCREMACABUS_delay),

        .BRAMDSOCMCLK(BRAMDSOCMCLK),
        .BRAMISOCMCLK(BRAMISOCMCLK),
        .CPMC405CLOCK(CPMC405CLOCK),
        .CPMC405CORECLKINACTIVE(CPMC405CORECLKINACTIVE_delay_1),
        .CPMC405CPUCLKEN(CPMC405CPUCLKEN_delay_1),
        .CPMC405JTAGCLKEN(CPMC405JTAGCLKEN_delay_1),
        .CPMC405SYNCBYPASS(CPMC405SYNCBYPASS_delay_1),
        .CPMC405TIMERCLKEN(CPMC405TIMERCLKEN_delay_1),
        .CPMC405TIMERTICK(CPMC405TIMERTICK_delay_1),
        .CPMDCRCLK(CPMDCRCLK),
        .CPMFCMCLK(CPMFCMCLK),
        .DBGC405DEBUGHALT(DBGC405DEBUGHALT_delay_1),
        .DBGC405EXTBUSHOLDACK(DBGC405EXTBUSHOLDACK_delay_1),
        .DBGC405UNCONDDEBUGEVENT(DBGC405UNCONDDEBUGEVENT_delay_1),
        .DSOCMRWCOMPLETE(DSOCMRWCOMPLETE_delay_1),
        .EICC405CRITINPUTIRQ(EICC405CRITINPUTIRQ_delay_1),
        .EICC405EXTINPUTIRQ(EICC405EXTINPUTIRQ_delay_1),
        .EMACDCRACK(EMACDCRACK_delay_1),
        .EXTDCRACK(EXTDCRACK_delay_1),
        .FCMAPUDCDCREN(FCMAPUDCDCREN_delay_1),
        .FCMAPUDCDFORCEALIGN(FCMAPUDCDFORCEALIGN_delay_1),
        .FCMAPUDCDFORCEBESTEERING(FCMAPUDCDFORCEBESTEERING_delay_1),
        .FCMAPUDCDFPUOP(FCMAPUDCDFPUOP_delay_1),
        .FCMAPUDCDGPRWRITE(FCMAPUDCDGPRWRITE_delay_1),
        .FCMAPUDCDLDSTBYTE(FCMAPUDCDLDSTBYTE_delay_1),
        .FCMAPUDCDLDSTDW(FCMAPUDCDLDSTDW_delay_1),
        .FCMAPUDCDLDSTHW(FCMAPUDCDLDSTHW_delay_1),
        .FCMAPUDCDLDSTQW(FCMAPUDCDLDSTQW_delay_1),
        .FCMAPUDCDLDSTWD(FCMAPUDCDLDSTWD_delay_1),
        .FCMAPUDCDLOAD(FCMAPUDCDLOAD_delay_1),
        .FCMAPUDCDPRIVOP(FCMAPUDCDPRIVOP_delay_1),
        .FCMAPUDCDRAEN(FCMAPUDCDRAEN_delay_1),
        .FCMAPUDCDRBEN(FCMAPUDCDRBEN_delay_1),
        .FCMAPUDCDSTORE(FCMAPUDCDSTORE_delay_1),
        .FCMAPUDCDTRAPBE(FCMAPUDCDTRAPBE_delay_1),
        .FCMAPUDCDTRAPLE(FCMAPUDCDTRAPLE_delay_1),
        .FCMAPUDCDUPDATE(FCMAPUDCDUPDATE_delay_1),
        .FCMAPUDCDXERCAEN(FCMAPUDCDXERCAEN_delay_1),
        .FCMAPUDCDXEROVEN(FCMAPUDCDXEROVEN_delay_1),
        .FCMAPUDECODEBUSY(FCMAPUDECODEBUSY_delay_1),
        .FCMAPUDONE(FCMAPUDONE_delay_1),
        .FCMAPUEXCEPTION(FCMAPUEXCEPTION_delay_1),
        .FCMAPUEXEBLOCKINGMCO(FCMAPUEXEBLOCKINGMCO_delay_1),
        .FCMAPUEXENONBLOCKINGMCO(FCMAPUEXENONBLOCKINGMCO_delay_1),
        .FCMAPUINSTRACK(FCMAPUINSTRACK_delay_1),
        .FCMAPULOADWAIT(FCMAPULOADWAIT_delay_1),
        .FCMAPURESULTVALID(FCMAPURESULTVALID_delay_1),
        .FCMAPUSLEEPNOTREADY(FCMAPUSLEEPNOTREADY_delay_1),
        .FCMAPUXERCA(FCMAPUXERCA_delay_1),
        .FCMAPUXEROV(FCMAPUXEROV_delay_1),
        .JTGC405BNDSCANTDO(JTGC405BNDSCANTDO_delay_1),
        .JTGC405TCK(JTGC405TCK),
        .JTGC405TDI(JTGC405TDI_delay_1),
        .JTGC405TMS(JTGC405TMS_delay_1),
        .JTGC405TRSTNEG(JTGC405TRSTNEG_delay_1),
        .MCBCPUCLKEN(MCBCPUCLKEN_delay_1),
        .MCBJTAGEN(MCBJTAGEN_delay_1),
        .MCBTIMEREN(MCBTIMEREN_delay_1),
        .MCPPCRST(MCPPCRST_delay_1),
        .PLBC405DCUADDRACK(PLBC405DCUADDRACK_delay_1),
        .PLBC405DCUBUSY(PLBC405DCUBUSY_delay_1),
        .PLBC405DCUERR(PLBC405DCUERR_delay_1),
        .PLBC405DCURDDACK(PLBC405DCURDDACK_delay_1),
        .PLBC405DCUSSIZE1(PLBC405DCUSSIZE1_delay_1),
        .PLBC405DCUWRDACK(PLBC405DCUWRDACK_delay_1),
        .PLBC405ICUADDRACK(PLBC405ICUADDRACK_delay_1),
        .PLBC405ICUBUSY(PLBC405ICUBUSY_delay_1),
        .PLBC405ICUERR(PLBC405ICUERR_delay_1),
        .PLBC405ICURDDACK(PLBC405ICURDDACK_delay_1),
        .PLBC405ICUSSIZE1(PLBC405ICUSSIZE1_delay_1),
        .PLBCLK(PLBCLK),
        .RSTC405RESETCHIP(RSTC405RESETCHIP_delay_1),
        .RSTC405RESETCORE(RSTC405RESETCORE_delay_1),
        .RSTC405RESETSYS(RSTC405RESETSYS_delay_1),
        .TIEC405DETERMINISTICMULT(TIEC405DETERMINISTICMULT_delay_1),
        .TIEC405DISOPERANDFWD(TIEC405DISOPERANDFWD_delay_1),
        .TIEC405MMUEN(TIEC405MMUEN_delay_1),
        .TIEPVRBIT10(TIEPVRBIT10),
        .TIEPVRBIT11(TIEPVRBIT11),
        .TIEPVRBIT28(TIEPVRBIT28),
        .TIEPVRBIT29(TIEPVRBIT29),
        .TIEPVRBIT30(TIEPVRBIT30),
        .TIEPVRBIT31(TIEPVRBIT31),
        .TIEPVRBIT8(TIEPVRBIT8),
        .TIEPVRBIT9(TIEPVRBIT9),
        .TRCC405TRACEDISABLE(TRCC405TRACEDISABLE_delay_1),
        .TRCC405TRIGGEREVENTIN(TRCC405TRIGGEREVENTIN_delay_1),
        .TIEAPUCONTROL(TIEAPUCONTROL_delay_1),
        .TIEAPUUDI1(TIEAPUUDI1_delay_1),
        .TIEAPUUDI2(TIEAPUUDI2_delay_1),
        .TIEAPUUDI3(TIEAPUUDI3_delay_1),
        .TIEAPUUDI4(TIEAPUUDI4_delay_1),
        .TIEAPUUDI5(TIEAPUUDI5_delay_1),
        .TIEAPUUDI6(TIEAPUUDI6_delay_1),
        .TIEAPUUDI7(TIEAPUUDI7_delay_1),
        .TIEAPUUDI8(TIEAPUUDI8_delay_1),
        .FCMAPUEXECRFIELD(FCMAPUEXECRFIELD_delay_1),
        .BRAMDSOCMRDDBUS(BRAMDSOCMRDDBUS_delay_1),
        .BRAMISOCMDCRRDDBUS(BRAMISOCMDCRRDDBUS_delay_1),
        .EMACDCRDBUS(EMACDCRDBUS_delay_1),
        .EXTDCRDBUSIN(EXTDCRDBUSIN_delay_1),
        .FCMAPURESULT(FCMAPURESULT_delay_1),
        .FCMAPUCR(FCMAPUCR_delay_1),
        .TIEDCRADDR(TIEDCRADDR_delay_1),
        .BRAMISOCMRDDBUS(BRAMISOCMRDDBUS_delay_1),
        .PLBC405DCURDDBUS(PLBC405DCURDDBUS_delay_1),
        .PLBC405ICURDDBUS(PLBC405ICURDDBUS_delay_1),
        .DSARCVALUE(DSARCVALUE_delay_1),
        .DSCNTLVALUE(DSCNTLVALUE_delay_1),
        .ISARCVALUE(ISARCVALUE_delay_1),
        .ISCNTLVALUE(ISCNTLVALUE_delay_1),
        .PLBC405DCURDWDADDR(PLBC405DCURDWDADDR_delay_1),
        .PLBC405ICURDWDADDR(PLBC405ICURDWDADDR_delay_1)
);

endmodule

module FPGA_startup_VIRTEX4 (bus_reset, ghigh_b, gsr, done, gwe, gts_b, shutdown, cclk, por);

output bus_reset;
output ghigh_b;
output gsr;
output done;
output gwe;
output gts_b;

input shutdown;
input cclk, por;

reg bus_reset, abus_reset;
reg ghigh_b, aghigh_b;
reg gsr, agsr;
reg done, adone;
reg gwe, agwe;
reg gts_b, agts_b;

reg [7:0] count;

always @ (posedge cclk or posedge por) begin
	if (por) count <= {8{1'b0}};
	else if (shutdown &&(count > {8{1'b0}})) count = count - 1;
	else if (!shutdown &&(count < {8'hFF})) count = count + 1;
end

always @ (posedge cclk or posedge por) begin
	if (por) begin
		{bus_reset,ghigh_b,gsr,done,gwe,gts_b} <= 6'b100000;
	end
	else begin
		{bus_reset,ghigh_b,gsr,done,gwe,gts_b} <= {abus_reset,aghigh_b,agsr,adone,agwe,agts_b};
	end
end

always @ (count) begin
	// defaults

	abus_reset = 1;
	aghigh_b = 0;
	agsr = 0;
	adone = 0;
	agwe = 0;
	agts_b = 0;

	// Trip times are in order for default sequence.
	if (count >= 8'h02) abus_reset = 0;
	if (count == 8'h17 || count == 8'h18) agsr = 1;
	if (count > 8'h27) aghigh_b = 1;
	if (count > 8'h31) adone = 1;
	if (count == 8'h33 || count == 8'h34) agsr = 1;
	if (count > 8'h36) agwe = 1;
	if (count > 8'h37) agts_b = 1;
end

endmodule // FPGA_startup
